<?php

function nmea_checksum($nmea_string) {
    //
    // Thanks to Adam Pierce
    // http://siliconsparrow.com/nmea-checksum-calculator/
    //

    $checksum = 0;
    for ($i = 0; $i < strlen($nmea_string); $i++) {
        $c = substr($nmea_string, $i, 1);
        $n = ord($c);
        if ($c == '$')
            $checksum = 0;
        else if($c == '*')
            break;
        else
            $checksum ^= $n;
    }
    return strtoupper(dechex($checksum));
}

$filename = '00000045.TSV';

$lines = file($filename);

echo "NMEA Data logger version 3.00\n";

// Parsen
$new_gpgga = 0;
foreach ($lines AS $line) {
    $nmea_line = explode(",", $line);
    $code = $nmea_line[0];
    switch ($code) {
        case '$GPGGA':
            list($code, $gpgga_time, $gpgga_latitude1, $gpgga_latitude2, $gpgga_longitude1, $gpgga_longitude2, $gpgga_gps_fix, $gpgga_satellites, $gpgga_hdop, $gpgga_altitude1, $gpgga_altitude2, $gpgga_height1, $gpgga_height2, $gpgga_dgps_time, $gpgga_checksum) = $nmea_line;
            $gpgga_latitude = $gpgga_latitude1.",".$gpgga_latitude2;
            $gpgga_longitude = $gpgga_longitude1.",".$gpgga_longitude2;
            $gpgga_altitude = $gpgga_altitude1.",".$gpgga_altitude2;
            $gpgga_height = $gpgga_height1.",".$gpgga_height2;
           
            $new_gpgga = 1;
            break;
        case '$SDDBT':
            if ($new_gpgga) {
                $sddbt_depth_f = $nmea_line[1].",".$nmea_line[2];
                $sddbt_depth_m = $nmea_line[3].",".$nmea_line[4];
                $sddbt_depth_m = (0+$sddbt_depth_m).',M';
                if ($sddbt_depth_m > 0) {
                    $nmea_string = "\$GPGGA,${gpgga_time},${gpgga_latitude},${gpgga_longitude},${gpgga_gps_fix},${gpgga_satellites},${gpgga_hdop},${sddbt_depth_m},${gpgga_height},${gpgga_dgps_time},";
                    $sddbt_checksum = nmea_checksum($nmea_string);
                    echo "${nmea_string}*${sddbt_checksum}\n";
                }
                $new_gpgga = 0;
            }
            break;
    }
}

?>