package slash.navigation.converter.gui.helper;

import java.io.IOException;
import java.util.Map;
import java.util.HashMap;

public class ElevationHelper {
	private Map<Integer, ElevationTile> elevationTile; 
	
	public ElevationHelper () {	
		this.elevationTile = new HashMap<Integer, ElevationTile> ();
	}
	
	public Integer getElevationFor (Double longitude, Double latitude) throws IOException  {
		double  dLon  = longitude;
		double  dLat  = latitude;
		int     nLon  = (int) dLon;								// runs from -180 to +180: 0 - 360
		int     nLat  = (int) dLat;     						// runs from  -90 to  +90: 0 - 180
		Integer nKey  = nLat * 100000 + nLon;					// @todo nLat +180 nLon +90 
		
		if (!elevationTile.containsKey (nKey)) {    			// If we don't have this tile loaded
			elevationTile.put (nKey, new ElevationTile (longitude, latitude)); // Open the tile file
		}

		return elevationTile.get(nKey).getElevationFor(longitude, latitude);
	}
}
